# Kirby License Agreement

Published: March 18, 2025  
Source: https://getkirby.com/license/2025-03-18

## About this Agreement

While Kirby's source code is publicly available, Kirby is **not free**. To use Kirby in production, you need to [purchase a license](https://getkirby.com/buy).

This End User License Agreement (the **"Agreement"**) is fundamental to the relationship between you and us. Therefore we recommend to read this Agreement carefully before you download, install or use Kirby.

If you do not agree to this Agreement, please do not download, install or use Kirby. Installation or use of Kirby signifies that you have read, understood, and agreed to be bound by this Agreement.

## Summary

This section summarizes the most important conditions of this Agreement to give you a quick overview:

- With your purchase you obtain a license. A license allows you to use Kirby according to this Agreement.
- Each project (defined by its URL) needs its own license. You need to purchase the right license for your project and/or client. You can find our license variants on <https://getkirby.com/buy>.
- In some explicitly listed cases, you can use Kirby without having to purchase a license. In these cases, this Agreement grants you the license directly. There are also cases where you can request a free or discounted license from us.
- Each license includes any Kirby version that gets released within three years from the date when you first activated your license. We also provide free security updates for older versions that may protect your project beyond three years.
- After those three years, you can continue to use Kirby for your project with any of these versions as long as you want.
- To use any newer version released after this time, you will need to upgrade your license.
- Upgrading your license extends the timeframe for an additional three years during which you can use new releases. You can perform the upgrade at any time.
- You have the right to transfer or reassign a license to another person or project if needed.
- There are some restrictions for use of Kirby that you can find below.

For the full license details, please read the Agreement in full. Only the following sections are legally binding.

## Definitions

Before we get started with the conditions of the Agreement, let's define the terms that will be used throughout it:

- When we refer to **"You"**, we mean the licensee. Before purchasing Kirby, that's the individual or company that has downloaded and/or installed Kirby for a Development Installation or Private Installation. When used for a Public Site, the licensee is the individual or company that has purchased the Kirby license or received a free license from Us on request. If you work on a client project and have purchased the Kirby license for your client, you (and _not_ the client) are the licensee.
- When we refer to **"We"**/**"Us"**/**"Our"**, we mean the licensor, the Content Folder GmbH & Co. KG. You can find Our company and contact information on Our [contact page](https://getkirby.com/contact).
- **"Client"** refers to the individual or company that is primarily responsible for and benefits from the Website, unless they are the licensee. You might create or work on the Website on behalf of the Client, either directly or through other intermediaries (e.g. as a freelancer for an agency that works on a client website).
- A **"Website"** is a single Kirby project that is defined by its domain name and root directory (e.g. `https://sub.example.com` or `https://example.com/example/`). Each (sub)domain and root directory is a separate Website, even if the projects are related in any way. Exception: If You use the cross-domain multi-language feature with the same `content` folder, these domains count as the same Website.
  You may use Kirby as a headless backend or as a static site generator. In these cases the Website is defined by the domain and root directory of the user- or visitor-facing frontend(s).
- A **"Development Installation"** is a Website that is installed purely for the purposes of development and client preview. It must only be accessible by a restricted number of users (like on a personal computer, on a server in a network with restricted access or when protecting a staging website with a password that only a restricted number of users know).
- A **"Private Installation"** is a Website that is installed purely for personal use. It must only be accessible by You and Your family.
- A **"Public Site"** is a Website that is _neither_ a Development Installation nor a Private Installation.
- A **"Minor Release"** is a stable Kirby release which adds smaller new features, minor functionality enhancements or bug fixes. This class of release is identified by the change of the revision to the right of the first decimal point, e.g. 4.1 to 4.2, 4.X.1 to 4.X.2.
- A **"Major Release"** is a stable Kirby release which incorporates major new features or enhancements that increase or change the core functionality of Kirby to a larger extent. It may also deprecate existing parts of the Source Code or change them in a breaking way. This class of release is identified by the change of the revision to the left of the first decimal point, e.g. 4.X to 5.0.
- A **"Major Generation"** is defined as all releases that share the revision to the left of the first decimal point, e.g. 4.0.0, 4.0.X, 4.X.0 and 4.X.X.
- The **"Source Code"** is defined as the contents of all files that are provided with Kirby and that make Kirby work. This includes (but is not limited to) all PHP, JavaScript, JSON, HTML and CSS files as well as all related image and other media files.
- The **"MIT-licensed Source Code Parts"** are defined as the parts of the Source Code for which a file header or code comment inside the same source file explicitly states the applicability of the MIT license.
- The **"Activation Date"** determines the included updates. It is defined like this:
	- For a newly purchased or granted license, it is the date when the license was first activated for use with a Public Site.
	- When You upgrade an already activated license, it is the date on which the upgrade was performed in Our [license hub](https://hub.getkirby.com). If the license is still within the Included Updates Period, the Activation Date of the upgrade license will be set to the end of the Included Updates Period of the existing license.
	- When You upgrade a license that had _not_ been activated before, the upgrade license adopts the unactivated state of the existing license. The Activation Date is set on first activation for use with a Public Site.
- The **"Included Updates Period"** is the time span of three (3) years after the Activation Date.
- Licensees (You), Clients and Websites are **"Qualified"** if they satisfy the purchase requirements from the ["Order Process" section](#order-process) of this Agreement.

Every time you see one of these capitalized terms in the following text, it has the meaning that has been explained above.

## Usage for a Public Site

Installing Kirby on or using it for a Public Site requires a [paid license](https://getkirby.com/buy). Once a paid license is needed, the license must be immediately activated to the Public Site’s domain name and root directory via our [license hub](https://hub.getkirby.com) or the activation feature in the Kirby Panel.

As Kirby is software and software is intangible, We don't sell it as such. Instead, this Agreement grants a license for each purchase to install and use a single instance of Kirby on a **specific Website**. Additional Kirby licenses must be purchased in order to install and use Kirby on **additional Websites**.

The license is **non-exclusive** (meaning that You are not the only one to whom We will issue a license) and **generally non-transferable** (meaning that the one who purchases the license is the licensee).

On request, We will **transfer** a license to anyone who would be allowed and Qualified to purchase the license by law and this Agreement. The new licensee will take over all rights and obligations of this Agreement from You at the moment We confirm the license transfer.

We will also **reassign** a license to another Qualified Website domain and root directory, if You confirm that the previous Website is no longer in operation and will not be operated with the same license in the future.

If the new licensee, Website or Client in a transfer or reassignment is not Qualified for the existing license, You or the new licensee need to **upgrade the license to the qualifying terms and conditions** before the transfer or reassignment can be performed.

> [!NOTE]
> If you need to transfer your Kirby license to another individual or company (for example to your client or a new agency) or reassign it to a different project, please get in touch directly at <support@getkirby.com>.

A license is valid for all Major Releases that We publish before the end of the Included Updates Period. It is also valid for all releases in those Major Generations independent of their release date. Whether a release is a Minor Release or Major Release is at Our sole discretion.

The use of releases in Major Generations that We publish after the Included Updates Period requires a **paid license upgrade**. An upgrade license replaces the existing license.

## Order Process

Our order process is conducted by Our online reseller [Paddle.com](https://paddle.com). Paddle.com is the Merchant of Record for all Our orders. Paddle provides all customer service inquiries and handles returns.

When purchasing a license, You are **responsible to choose the right license** based on You and the Website project. Different license variants can come with certain requirements towards You and/or the Website project. We publish all such requirements on <https://getkirby.com/buy> in a way that makes them clearly visible before the purchase. With Your purchase, You confirm that You and the Website project qualify for the selected license variant.

If the Website is created for a Client, You need to make sure that the **Client qualifies for the selected license**.

If You purchase licenses **in advance**, You need to ensure to only use the license(s) for projects that satisfy the requirements for the selected license variant(s).

We **reserve the right to verify** at any time after the purchase whether You, the Website and (if applicable) the Client are Qualified. Changes to the situation of You, the Website or the Client as well as changes to the published information on Our "Buy" page after the purchase or after the assignment to a Client do _not_ take effect on an existing license unless You upgrade the license or We transfer or reassign the license on Your request.

## Free Licenses

Kirby can be used **for free in the following cases**.

> [!NOTE]
> Please note that the restrictions and all other clauses of this Agreement also apply to free licenses. You may especially _not_ alter or circumvent the licensing features.

### Usage for a Development Installation

We believe that it should be possible to test and evaluate software before having to purchase a license. Also, We understand that a web project first needs to be built in a protected environment before it can be published.

Therefore, installing and using Kirby on a personal computer (like a desktop PC, notebook or tablet) or server for a Development Installation is **free** for as long as You need. If You have already purchased a license, You do *not* need to activate it to the development domain(s) of the project.

> [!NOTE]
> The usage of Kirby in production (with the intention to handle production data or content) is _never_ considered a Development Installation, even in internal apps or systems.

### Usage for a Private Installation

You may also install and use Kirby for **free** in Private Installations as long as they are not accessible by anyone except You and Your family.

> [!NOTE]
> Our [definition](#definitions) of a Private Installation allows the following use cases:
>
> - Private sites for personal use, for example:
>   - Apps for You personally (like a personal diary)
>   - Apps for You as a freelancer (like a bookkeeping, invoicing or project management app)
>   - Apps for Your family (like a private photo gallery)
> - Experimental local Kirby setups for Your personal use (for example to try out Kirby features)
> 
> However, the following use cases are _not_ covered and need a **[paid license](#usage-for-a-public-site)**:
>
> - Intranets for companies, authorities or organizations, no matter if on a local or public server
> - (Internal) apps for teams or entire companies, authorities or organizations
> - Websites that are accessible by the public, even for personal/non-commercial purposes
> - Use of Kirby as a local CMS for a static or headless site without a license for the frontend domain(s)

### Free Licenses on Request

We provide free or discounted licenses for specific purposes:

- students,
- selected educational projects, social and environmental organizations, charities and non-profits with insufficient funding and
- demo sites showcasing a Kirby extension (plugin or theme).

Unlike licenses for Development Installations or Private Installations, these free or discounted licenses are not granted by this Agreement directly. You need to request them from Us via email to <support@getkirby.com>. Any discounts or free licenses are at Our sole discretion.

Should We grant a free or discounted license under the terms of this section, You will receive a license code for use with a Public Site. The [section "Usage for a Public Site"](#usage-for-a-public-site) as well as all other terms of this Agreement apply with the following modifications:

- We will only transfer or reassign free or discounted licenses if the new licensee or project qualifies for the free or discounted license at Our sole discretion.
- You may upgrade free or discounted licenses to future Major Generations like paid licenses. We will grant free or discounted upgrades under the terms of this section.

## Restrictions

### Legal Restrictions

You may only use Kirby in a manner that complies with any and all **applicable laws** in the jurisdictions in which You use Kirby. Please respect all applicable restrictions concerning **privacy and intellectual property rights**.

### Making Copies

You may make **copies of Kirby** in any machine readable form solely for the **following purposes**, provided that You reproduce Kirby in its original form and with all proprietary notices on the copy:

- when deploying a Website to a server,
- when developing a Website on a personal computer or server,
- when working on code contributions to Kirby or
- as a backup.

You may _not_ reproduce Kirby or its Source Code, in whole or in part, for **any other purpose**, except if granted below.

### Modification of the Source Code

You may **alter, modify or extend the Source Code** for Your own use or with the intention to contribute Your changes back to Kirby. You may also **commission a third party** to perform those modifications for You.

However You may _not_:

- **alter or circumvent the licensing features**, including (but not limited to) the license validation and payment prompts,
- **remove or alter any proprietary notices** on Kirby or
- **resell, redistribute or transfer** the modified or derivative version.

> [!NOTE]
> Please note that We **can't provide technical support** for modified or derivative versions of the Source Code.

### Your Relationship to Third Parties

You are generally _not_ allowed to **sell, assign, license, disclose, distribute, or otherwise transfer or make available** Kirby or its Source Code, in whole or in part, in any form to any third parties.

The following cases are exempted from this restriction:

- Kirby licenses may be transferred to a new licensee by requesting the transfer from Us ([see above](#usage-for-a-public-site)).
- You may create Websites for third parties (e.g. as an agency or freelancer for a client). Together with this Website, You may bill Your client for the used Kirby license. You may also include the license price in a flat rate. Please note that the licensee in both of these cases is still You unless You request to transfer the license to Your client. If Your price exceeds the price You paid to Us, You need to give Your client the option to purchase the license directly from Us.
- You may make Kirby available to customers via a Software-as-a-Service (SaaS) offering, provided You ensure that each Website has a valid Kirby license purchased either by You or Your customer. If multiple customers share a Website, each customer needs at least one license. Your offering _must not_ appear to be provided or officially endorsed by Us.
- You may make a Kirby installation available to employees or partners of You or Your Website client. You may also disclose and distribute Kirby’s Source Code to Your client together with the source code of the Website You created for them.
- You may disclose the Source Code to individuals or companies that are involved in the development or operation of Your Website (e.g. agencies, design or development freelancers, hosting providers or administrators).
- You may disclose, distribute and make available extracted parts of the Source Code according to the conditions of the following section "Extraction of Source Code parts".

> [!NOTE]
> E.g. the following cases are explicitly **_not_ allowed**:
> 
> - Selling, licensing or distributing a new product based on Kirby that modifies or hides Kirby’s identity as a Content Management System (CMS)
> - Forking Kirby and selling the modified version ([see above](#modification-of-the-source-code))
> - Buying licenses in bulk and reselling them in your own shop
> - Bundling or including Kirby’s full Source Code in the publication and/or distribution of a Website’s source code or a (free or paid) theme or plugin (please use Git submodules or Composer or provide a link to Our repository or website instead)

### Extraction of Source Code parts

We provide the Source Code as a complete unit for use according to this Agreement.

Reuse of code parts in other programs or projects is _only_ permitted in the cases stated in the following sections. You may _not_ extract the Source Code or parts of the Source Code in any other way or for any other purpose.

#### Extraction of MIT-licensed Source Code Parts

Permission is hereby granted, free of charge, to any person obtaining a copy of MIT-licensed Source Code Parts, to deal in the MIT-licensed Source Code Parts without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the MIT-licensed Source Code Parts, and to permit persons to whom the MIT-licensed Source Code Parts is furnished to do so, subject to the following conditions:

The copyright notice to Bastian Allgeier and this permission notice shall be included in all copies or substantial portions of the MIT-licensed Source Code Parts.

THE MIT-LICENSED SOURCE CODE PARTS ARE PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE MIT-LICENSED SOURCE CODE PARTS OR THE USE OR OTHER DEALINGS IN THE MIT-LICENSED SOURCE CODE PARTS.

#### Extraction for Extensions

You may extract, use, disclose and distribute copies or adapted copies of individual parts of the Source Code (such as component templates), including those not licensed under the terms of the MIT license but excluding those covered by third-party licenses, if both of the following conditions are met:

- You use the code parts in or disclose/distribute them as part of an extension (plugin or theme) that You solely intend to be used with Kirby.
- Every copied or adapted code part carries a clear note that references these conditions as well as Our copyright and this Agreement. You may use the following example as a template:
  ```
  /**
   * The following code was copied or adapted from the source code of
   * Kirby CMS and may not be used outside of licensed Kirby projects.
   *
   * @copyright Bastian Allgeier
   * @license https://getkirby.com/license
   */
  ```

### Disallowed Uses

The following uses of Kirby are _not_ covered by this Agreement and will result in the termination of the license:

- Direct or indirect use of Kirby in **critical infrastructure** (e.g. water and energy services, public health, financial services, public security services) or **high-risk environments** (e.g. handling of harmful or dangerous materials). The use in Websites without connection to core processes is allowed.
- Use of Kirby for Websites that contain **misinformation, hate speech or discriminating content** based on age, gender, gender identity, race, sexuality, religion, nationality, serious illnesses or disabilities, no matter who authored this content. Misinformation is defined as content that is false or misleading and may lead to significant risk of physical or societal harm.
- Use of Kirby by **companies or individuals who**:
  - lobby for, promote, derive a majority of income from or are significantly invested in:
    - the production of tobacco or weapons,
    - any prison or jail operated for profit,
    - any action or facility that supports or contributes to:
      - gambling, adversely addictive behaviours or
      - deforestation.
  - lobby against, or derive a majority of income from actions that discourage or frustrate:
    - peace,
    - access to the rights set out in the Universal Declaration of Human Rights and the Convention on the Rights of the Child,
    - peaceful assembly and association (including worker associations),
    - a safe environment or action to curtail the use of fossil fuels or to prevent climate change or
    - democratic processes.

## Technical Support

Technical support is **provided as described on Our website** at <https://getkirby.com>. **No representations or guarantees** are made regarding the response time in which support questions are answered, however We will do Our best to respond quickly.

For each Major Generation, We aim to provide **security support for three (3) years** after the Major Release. Security support means that We will provide free security updates for the supported releases, which will include fixes for security vulnerabilities according to the following rules:
	- We published a security advisory on <https://getkirby.com/security> within the respective security support period. We will publish vulnerabilities on this page as soon as they are known to Us and an official fix for any supported release is available.
	- The latest release of the supported Major Generation is affected by the vulnerability.

With each vulnerability, We aim to publish the security advisory and security updates for all supported Major Generations at the same time.

> [!NOTE]
> You can find up-to-date information on our currently supported versions in our [public security policy](https://getkirby.com/security).

We reserve the right to **limit technical support for free licenses**.

## Refund Policy

We offer a **14-day**, money back refund policy if Kirby didn't work out for Your project.

> [!NOTE]
> If you need a refund, please get in touch directly at <support@getkirby.com>.

## No Warranty

KIRBY IS OFFERED ON AN **"AS-IS" BASIS** AND **NO WARRANTY**, EITHER EXPRESSED OR IMPLIED, IS GIVEN. WE EXPRESSLY DISCLAIM ALL WARRANTIES OF ANY KIND, WHETHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. YOU ASSUME ALL RISK ASSOCIATED WITH THE QUALITY, PERFORMANCE, INSTALLATION AND USE OF KIRBY INCLUDING, BUT NOT LIMITED TO, THE RISKS OF PROGRAM ERRORS, DAMAGE TO EQUIPMENT, LOSS OF DATA OR SOFTWARE PROGRAMS, OR UNAVAILABILITY OR INTERRUPTION OF OPERATIONS. **YOU ARE SOLELY RESPONSIBLE** FOR DETERMINING THE APPROPRIATENESS OF USE OF KIRBY AND ASSUME ALL RISKS ASSOCIATED WITH ITS USE. THIS PARAGRAPH ALSO APPLIES TO YOU IF YOU ARE NOT THE LICENSEE (E.G. IF YOU USE KIRBY WHILE SOMEONE ELSE IS THE LICENSEE).

## Term, Termination and Modification

You may **indefinitely use** all Kirby versions that are covered by Your license under this Agreement until either party **terminates this Agreement** as described in this section.

**You** may terminate the Agreement at any time.

**We** may only terminate the Agreement if You or any individual or company who works with Kirby or uses it on Your behalf has violated or failed to comply with terms of this Agreement. If Your compliance with the Agreement can be restored by fixing the violation or non-compliance, We will first contact You with information on the specific term that was violated or not complied with and will allow reasonable time of at least 14 days before We will decide on a license termination. Should We be in the position to terminate a license according to this paragraph, other or all licenses granted to You may be terminated for the same reason(s) at the same time or at any later date.

Termination takes effect upon notice to the other party in textual form (via email or letter). Upon termination, the specified **licenses granted to You will terminate**, and You will **immediately uninstall and cease all use** of Kirby. If not all licenses are terminated, You may continue to use Kirby for the Websites with active licenses. The sections entitled "No Warranty", "Indemnification" and "Limitation of Liability" will **survive any termination** of this Agreement.

We may **modify Kirby and this Agreement** with notice to You either via email or by publishing content on the Kirby website at https://getkirby.com, including but not limited to changing the functionality or appearance of Kirby. Any such modification will **become binding on You** unless You terminate this Agreement. Changes to this Agreement that constrain Your rights to a great extent will only become effective with Your approval in textual or electronic form.

## Indemnification

By accepting the Agreement, you **agree to indemnify and otherwise hold harmless** Us as well as Our officers, employees, agents, subsidiaries, affiliates and other partners from any direct, indirect, incidental, special, consequential or exemplary damages arising out of, relating to, or resulting from your use of Kirby or any other matter relating to Kirby. This paragraph also applies to you if you are not the licensee (e.g. if you use Kirby while someone else is the licensee).

## Limitation of Liability

YOU EXPRESSLY UNDERSTAND AND AGREE THAT **WE SHALL NOT BE LIABLE** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL OR EXEMPLARY DAMAGES, INCLUDING BUT NOT LIMITED TO, DAMAGES FOR LOSS OF PROFITS, GOODWILL, USE, DATA OR OTHER INTANGIBLE LOSSES (EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES). SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF THE LIMITATION OR EXCLUSION OF LIABILITY FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES. ACCORDINGLY, **SOME OF THE ABOVE LIMITATIONS MAY NOT APPLY TO YOU**. **IN NO EVENT WILL OUR TOTAL CUMULATIVE DAMAGES EXCEED** THE FEES YOU PAID TO US UNDER THIS AGREEMENT IN THE MOST RECENT TWELVE-MONTH PERIOD. THIS PARAGRAPH ALSO APPLIES TO YOU IF YOU ARE NOT THE LICENSEE (E.G. IF YOU USE KIRBY WHILE SOMEONE ELSE IS THE LICENSEE).

## All Rights Reserved

Bastian Allgeier **owns all rights**, title and interest to Kirby (including all intellectual property rights) and **reserves all rights to Kirby** that are not expressly granted in this Agreement.

In the event that Kirby will no longer be actively maintained, Bastian Allgeier will provide the Source Code under the terms of a free and open source software (FOSS) license as far as legally and contractually possible.

## Applicable Law & Place of Jurisdiction

1. For all disputes arising out of or in connection with this Agreement, the courts competent for Neckargemünd, Germany, shall have exclusive jurisdiction. However, We shall have the choice to file lawsuits against You before the courts competent for Your place of business.
2. If You reside in Germany, para. 1 shall only apply if You are a merchant, a legal entity under public law or a special fund under public law.
3. If You don't reside in Germany, but in a different member state of the European Union, para. 1 shall only apply if You are not a consumer under Art. 17 of the regulation (EU) No. 1215/2012. In that case, You shall be entitled to file actions against Us either at Our place of business or at the courts competent at the place where You usually reside. We, on the other hand, are only entitled to bring proceedings against You in the courts of the Member State in which You are domiciled.
4. If You neither reside in Germany nor in a member state of the EU, the applicability of para. 1 remains unaffected.

## Severability Clause

Should any provision of this Agreement be or become invalid, void or unenforceable, in whole or in part, at present or in the future, this shall not affect the validity of the remaining provisions of this Agreement. The same shall apply if a gap requiring supplementation arises after conclusion of this Agreement. The parties shall replace the invalid, void or unenforceable provision or gap requiring filling by a valid provision which in its legal or economic content takes account of the invalid, void provision and the overall content of the agreement. § Section 139 of the German Civil Code (partial invalidity) is expressly waived.

## Questions?

Due to Kirby's flexibility, you may have special use cases or requirements that don't fit this Agreement.

If that's the case or if you have any questions, feel free to [get in touch](mailto:support@getkirby.com). We are happy to think outside the box and find custom license solutions for your creative application of Kirby.
